import pandas as pd
import subprocess
import os

results_folder = "../evaluations"
output_folder = "../images"
gnuplot_folder = "D:/Tools/Gnuplot/bin"

plot_definition = """set term postscript color enhanced font 'Helvetica,14'
set output '{0}'
set datafile separator ','
set grid
set style line 1 pt 8
set style line 2 lt rgb '#00C000'
set style line 5 lt rgb '#FFD800'
set style line 6 lt rgb '#4E0000'

set style line 7 lt rgb '#e41a1c'
set style line 8 lt rgb '#377eb8'
set style line 9 lt rgb '#4daf4a'
set style line 10 lt rgb '#984ea3'
set style line 11 lt rgb '#ff7f00'
set style line 12 lt rgb '#999999'

set format x '%.0s %c'
set format y '%.0s'
set ylabel '{1}'
set xlabel 'Processed instances'
set key nobox vertical bottom right inside
set format y '%1.2f'
plot  [{2}:{3}][{4}:{5}]"""
line_definition = "'{0}' using 1:{1}:(1.0) smooth bezier with linespoints ls {2} lw 3 pointinterval 4 title '{3}'"
min_x = "1000"
max_x = ""
min_y = ""
max_y = ""

measures = ["Accuracy", "AUC", "G-Mean", "Kappa", "Kappa M", "Recall"]
measure_columns = {"Accuracy": 7, "AUC": 5, "G-Mean": 11, "Kappa": 8, "Kappa M": 13, "Recall": 12}
classifiers = ["Bayes", "Bagging", "VFDT", "VFDTAdaptive", "AUE", "SERA"]
classifier_acronyms = {"Bayes": "NB", "Bagging": "Bag",  "VFDT": "HT", "VFDTAdaptive":"HT_{ADWIN}", "AUE": "AUE", "SERA": "SERA"}


def run_gnuplot(script):
    with open("tmp.plt", "w") as script_file:
        script_file.write(script)

    subprocess.call(os.path.join(gnuplot_folder, "gnuplot") + " tmp.plt", cwd=os.path.dirname(__file__), shell=True)
    os.remove("tmp.plt")


for (root, dirs, files) in os.walk(results_folder):
    stream = os.path.basename(root)
    if stream == "evaluations":
        continue

    print("Visualizations for {0} dataset".format(stream))

    # All measures for each classifier separately
    for classifier in classifiers:
        script = plot_definition.format(os.path.join(os.path.abspath(output_folder), stream + "_" + classifier + ".eps"),
                                        "Measure value", min_x, max_x, min_y, max_y)

        for line_num, measure in enumerate(measures):
            script += line_definition.format(os.path.join(os.path.abspath(root), classifier + ".csv"),
                                             measure_columns[measure], line_num + 7, measure) + ", "
        run_gnuplot(script[:-2])

    # All classifiers for each measure separately
    for measure in measures:
        script = plot_definition.format(os.path.join(os.path.abspath(output_folder), stream + "_" + measure + ".eps"),
                                        measure, min_x, max_x, min_y, max_y)

        for line_num, classifier in enumerate(classifiers):
            script += line_definition.format(os.path.join(os.path.abspath(root), classifier + ".csv"),
                                             measure_columns[measure], line_num + 1, classifier_acronyms[classifier]) + ", "
        run_gnuplot(script[:-2])

